/**
 * Beschrijft het personage strijder van een computergame.
 * 
 * @author Dominiek Vandewalle 
 * @version 2015-04-15
 */
public abstract class Strijder
{
    private String naam;
    protected int aantalLevens;
    protected int gezondheid;
    
    /**
     * Constructor voor objecten van de klasse Strijder.
     * @param   naam    De naam van de strijder.
     */
    public Strijder(String naam)
    {
        this.naam = naam;
        aantalLevens = 3;
        gezondheid = 100;
    }
    
    /**
     * Schiet op een andere strijder.
     * @param   tegenstander    De strijder die beschoten wordt.
     */
    public void schiet(Strijder tegenstander)
    {
        if(gezondheid > 0)
        {
           tegenstander.geraakt();
        }  
    }
    
    /**
     * Vermindert de gezondheidstoestand van een strijder.
     */
    public abstract void geraakt();
 
    /**
     * Toont de gezondheidsstatus van de strijder in het terminalvenster.
     */
    public void printInfo()
    {
        System.out.println("Naam: " + naam);
        System.out.println("Levens: " + aantalLevens);
        System.out.println("Gezondheid: " + gezondheid);
    }
}